#ifndef NEWCATEGORYDIALOG_H
#define NEWCATEGORYDIALOG_H

#include <QDialog>

class QLineEdit;
class QMaemo5ValueButton;

class NewCategoryDialog : public QDialog
{
    Q_OBJECT

public:
    explicit NewCategoryDialog(QWidget *parent = 0);
    ~NewCategoryDialog();

public slots:
    void setName(const QString &name);
    void setPath(const QString &path);

private slots:
    void onNameTextChanged(const QString &text);
    void showFileDialog();
    void addCategory();

signals:
    void addCategory(const QString &name, const QString &path);
    
private:
    QLineEdit *m_nameEdit;
    QMaemo5ValueButton *m_pathSelector;
    QPushButton *m_doneButton;
    QString m_path;
};

#endif // NEWCATEGORYDIALOG_H
