#ifndef HOTFILE_H
#define HOTFILE_H

#include <QObject>
#include <QUrl>
#include "serviceplugin.h"

class QTimer;

class Hotfile : public ServicePlugin
{
    Q_OBJECT
    Q_INTERFACES(ServiceInterface)

public:
    explicit Hotfile(QObject *parent = 0);
    ServicePlugin* createServicePlugin() { return new Hotfile; }
    inline QString iconName() const { return QString("hotfile.jpg"); }
    inline QString serviceName() const { return QString ("Hotfile"); }
    QRegExp urlPattern() const;
    bool urlSupported(const QUrl &url) const;
    void checkUrl(const QUrl &url);
    void getDownloadRequest(const QUrl &url);
    inline bool loginSupported() const { return true; }
    void login(const QString &username, const QString &password);
    inline bool recaptchaRequired() const { return true; }
    inline QString recaptchaKey() const { return m_captchaKey; }
    inline int maximumConnections() const { return m_connections; }
    bool cancelCurrentOperation();

public slots:
    void submitCaptchaResponse(const QString &challenge, const QString &response);

private:
    void startWait(int msecs);

private slots:
    void checkLogin();
    void checkUrlIsValid();
    void onWebPageLoaded();
    void onFormSubmitted();
    void updateWaitTime();
    void onWaitFinished();
    void submitForm();
    void onCaptchaSubmitted();

signals:
    void currentOperationCancelled();

private:
    QUrl m_url;
    QString m_wait;
    QString m_waitHash;
    QString m_tm;
    QString m_tmHash;
    QString m_upidHash;
    QString m_captchaKey;
    QTimer *m_waitTimer;
    int m_waitTime;
    int m_connections;
};

#endif // HOTFILE_H
