#ifndef URLRETRIEVER_H
#define URLRETRIEVER_H

#include <QObject>
#include <QQueue>
#include <QUrl>
#include <QStringList>
#include <QMutex>

class QNetworkReply;
class UrlProcessor;

class UrlRetriever : public QObject
{
    Q_OBJECT

    Q_PROPERTY(int progress
               READ progress
               NOTIFY progressChanged)

public:
    int progress() const;

    Q_INVOKABLE QList<QUrl> results() const;
    Q_INVOKABLE QString resultsString() const;

    static UrlRetriever* instance();

public slots:
    void addUrlToQueue(const QUrl &url);
    void addUrlToQueue(const QString &url);
    void addUrlsToQueue(QList<QUrl> urls);
    void addUrlsToQueue(QStringList urls);
    void parseUrlsFromText(const QString &text);
    void importUrlsFromTextFile(const QString &filePath);

    void cancel();
    void clearResults();

private:
    UrlRetriever();
    ~UrlRetriever();

    void getWebPage(const QUrl &url);

private slots:
    void checkWebPage();
    void onUrlsProcessed(const QList<QUrl> &urls);

signals:
    void busy(const QString &message, int numberOfOperations);
    void finished();
    void progressChanged(int progress);
    void cancelled();
    
private:
    static UrlRetriever *m_instance;

    UrlProcessor *m_processor;
    QNetworkReply *m_reply;

    QQueue<QUrl> m_urlQueue;
    QList<QUrl> m_results;

    bool m_index;
    bool m_total;
    bool m_cancelled;
};

class UrlProcessor : public QObject
{
    Q_OBJECT

    friend class UrlRetriever;

private:
    UrlProcessor();
    ~UrlProcessor();

private slots:
    void processUrls(const QString &response);

signals:
    void urlsProcessed(const QList<QUrl> &urls);
};

#endif // URLRETRIEVER_H
