#ifndef PLUGINSETTINGSSPINBOX_H
#define PLUGINSETTINGSSPINBOX_H

#include <QSpinBox>
#include <QVariant>

class PluginSettingsSpinbox : public QSpinBox
{
    Q_OBJECT

public:
    explicit PluginSettingsSpinbox(QWidget *parent = 0);
    ~PluginSettingsSpinbox();

    inline QString key() const { return m_key; }
    inline QVariant defaultValue() const { return m_default; }
    
public slots:
    void setKey(const QString &key);
    void setDefaultValue(const QVariant &value);
    void load();

private slots:
    void onValueChanged(int value);

private:
    QString m_key;
    QVariant m_default;
};

#endif // PLUGINSETTINGSSPINBOX_H
