#include "mainwindow.h"
#include "../shared/transfer.h"
#include "../shared/session.h"
#include "../shared/definitions.h"
#include "../dbus/dbusservice.h"
#include "../dbus/dbusserviceadaptor.h"
#include <QApplication>

int main(int argc, char *argv[])
{
    QApplication app(argc, argv);
    app.setApplicationName("QDL");
    app.setApplicationVersion(VERSION_NUMBER);
    app.setWindowIcon(QIcon::fromTheme("qdl"));
    app.setQuitOnLastWindowClosed(false);

    qRegisterMetaType< QList<Transfer*> >("QList<Transfer*>");

    QIcon::setThemeName("elementary-xfce");

    Session session;

    DBusServiceAdaptor adaptor(DBusService::instance());

    QDBusConnection connection = QDBusConnection::sessionBus();
    connection.registerService("com.marxoft.QDL");
    connection.registerObject("/", DBusService::instance());

    MainWindow window;
    window.show();

    return app.exec();
}
