import QtQuick 1.1
import com.nokia.symbian 1.1

Item {
    id: root

    height: 60

    property alias text: textField.text
    property alias placeholderText: textField.placeholderText

    signal accepted(string text)

    BorderImage {
        anchors.fill: parent
        source: privateStyle.imagePath("qtg_fr_tab_bar", false)
        border {
            left: platformStyle.borderSizeMedium
            top: platformStyle.borderSizeMedium
            right: platformStyle.borderSizeMedium
            bottom: platformStyle.borderSizeMedium
        }
    }

    TextField {
        id: textField

        anchors {
            left: parent.left
            leftMargin: 10
            right: parent.right
            rightMargin: 10
            verticalCenter: parent.verticalCenter
        }

        platformRightMargin: 55

        Keys.onEnterPressed: {
            root.accepted(textField.text);
            textField.focus = false
            textField.closeSoftwareInputPanel()
            textField.text = ""
            clearButton.state = "ClearHidden"
        }

        Keys.onReturnPressed: {
            root.accepted(textField.text);
            textField.focus = false
            textField.closeSoftwareInputPanel()
            textField.text = ""
            clearButton.state = "ClearHidden"
        }

        onTextChanged: {
            if (textField.text) {
                clearButton.state = "ClearVisible"
            } else {
                clearButton.state = "ClearHidden"
            }
        }
        onActiveFocusChanged: {
            if (!textField.activeFocus) {
                textField.closeSoftwareInputPanel()
            }
        }

        inputMethodHints: Qt.ImhNoPredictiveText | Qt.ImhNoAutoUppercase
    }

    Image {
        id: clearButton; objectName: "clearButton"
        height: platformStyle.graphicSizeSmall
        width: platformStyle.graphicSizeSmall
        anchors.right: textField.right
        anchors.rightMargin: platformStyle.paddingSmall
        anchors.verticalCenter: textField.verticalCenter
        state: "ClearHidden"
        source: privateStyle.imagePath(
                    clearMouseArea.pressed ? "qtg_graf_textfield_clear_pressed"
                                           : "qtg_graf_textfield_clear_normal", false)

        MouseArea {
            id: clearMouseArea
            anchors.fill: parent
            onClicked: {
                textField.focus = false
                textField.cursorVisible = false
                textField.closeSoftwareInputPanel()
                textField.text = ""
                clearButton.state = "ClearHidden"
            }
        }

        states: [
            State {
                name: "ClearVisible"
                PropertyChanges {target: clearButton; opacity: 1}
            },
            State {
                name: "ClearHidden"
                PropertyChanges {target: clearButton; opacity: 0}
            }
        ]

        transitions: [
            Transition {
                from: "ClearVisible"; to: "ClearHidden"
                NumberAnimation { properties: "opacity"; duration: 250; easing.type: Easing.Linear }
            },
            Transition {
                from: "ClearHidden"; to: "ClearVisible"
                NumberAnimation { properties: "opacity"; duration: 250; easing.type: Easing.Linear }
            }
        ]

    }
}
