import QtQuick 1.1
import com.nokia.symbian 1.1
import "scripts/createobject.js" as ObjectCreator

SelectionListItem {
    id: root

    property string __key
    property variant __list

    function setList(key, defaultValue, list) {
        root.__key = key;
        root.__list = list;
        var value = Settings.setting(key);

        if (value === undefined) {
            root.subTitle = defaultValue;
            Settings.setSetting(key, defaultValue);
        }
        else {
            var i = 0;

            while ((!root.subTitle) && (i < list.length)) {
                if (list[i].value === value) {
                    root.subTitle = list[i].name;
                }

                i++;
            }
        }
    }

    function showSelectionDialog() {
        var dialog = ObjectCreator.createObject(Qt.resolvedUrl("PluginSettingsSelectionDialog.qml"), pageStack);
        dialog.titleText = root.title;

        for (var i = 0; i < root.__list.length; i++) {
            dialog.model.addItem(root.__list[i].name, root.__list[i].value);
        }

        dialog.setValue(Settings.setting(root.key));
        dialog.valueChosen.connect(root.onValueChosen);
        dialog.open();
    }

    function onValueChosen(name, value) {
        root.subTitle = name;
        Settings.setSetting(root.__key, value);
    }

    width: !parent ? screen.width : parent.width
    height: 80
    onClicked: root.showSelectionDialog()
}
