import QtQuick 1.1
import com.nokia.meego 1.0
import "file:///usr/lib/qt4/imports/com/nokia/meego/UIConstants.js" as UI

Item {
    id: root

    function close() {
        root.visible = false;
        progressBar.value = 0;
        UrlCheckModel.clear();
    }

    ListView {
        id: view

        anchors {
            top: parent.top
            left: parent.left
            right: parent.right
            bottom: column.top
            margins: UI.PADDING_DOUBLE
        }

        model: UrlCheckModel

        header: Item {
            width: view.width
            height: 48

            Label {
                id: urlLabel

                anchors {
                    left: parent.left
                    leftMargin: 5
                    verticalCenter: parent.verticalCenter
                }

                verticalAlignment: Text.AlignVCenter
                text: qsTr("URL")
            }

            Label {
                id: okLabel

                anchors {
                    right: parent.right
                    rightMargin: 5
                    verticalCenter: parent.verticalCenter
                }

                verticalAlignment: Text.AlignVCenter
                text: qsTr("OK") + "?"
            }

            Rectangle {
                height: 1
                anchors {
                    left: parent.left
                    leftMargin: 5
                    right: parent.right
                    rightMargin: 5
                    bottom: parent.bottom
                }

                color: UI.COLOR_INVERTED_SECONDARY_FOREGROUND
                opacity: 0.5
            }

            Rectangle {
                width: 1
                anchors {
                    top: parent.top
                    right: okLabel.left
                    bottom: parent.bottom
                    margins: 5
                }

                color: UI.COLOR_INVERTED_SECONDARY_FOREGROUND
                opacity: 0.5
            }
        }

        delegate: UrlCheckDelegate {}
    }

    ScrollDecorator {
        flickableItem: view
    }

    Column {
        id: column

        spacing: UI.PADDING_DOUBLE
        anchors {
            left: parent.left
            right: parent.right
            bottom: parent.bottom
            margins: UI.PADDING_DOUBLE
        }

        ProgressBar {
            id: progressBar

            width: parent.width
            value: 0
            maximumValue: 100
        }

        Label {
            font.pixelSize: 18
            font.italic: true
            text: UrlChecker.urlChecksCancelled ? qsTr("Cancelled") : progressBar.value < progressBar.maximumValue ? qsTr("Checking URLs") : qsTr("Complete")
        }

        Button {
            x: Math.floor((parent.width / 2) - (width / 2))
            text: (UrlChecker.urlChecksCancelled) || (progressBar.value == progressBar.maximumValue) ? qsTr("Close") : qsTr("Cancel")
            onClicked: (UrlChecker.urlChecksCancelled) || (progressBar.value == progressBar.maximumValue) ? root.close() : UrlChecker.urlChecksCancelled = true
        }
    }
}
