import QtQuick 1.1
import com.nokia.meego 1.0

Item {
    id: root

    signal clicked

    width: parent.width
    height: 80

    Rectangle {
        anchors.fill: parent
        color: UI.COLOR_INVERTED_SECONDARY_FOREGROUND
        opacity: 0.5
        visible: mouseArea.pressed
    }

    ServiceIcon {
        id: sIcon

        anchors {
            left: parent.left
            leftMargin: UI.PADDING_DOUBLE
            verticalCenter: parent.verticalCenter
        }
        iconSource: iconPath + pluginIcon
    }

    Label {
        id: title

        anchors {
            left: sIcon.right
            leftMargin: UI.PADDING_DOUBLE
            right: dIcon.left
            rightMargin: UI.PADDING_DOUBLE
            verticalCenter: parent.verticalCenter
        }

        font.bold: true
        verticalAlignment: Text.AlignVCenter
        elide: Text.ElideRight
        text: pluginName
    }

    Image {
        id: dIcon

        anchors {
            right: parent.right
            rightMargin: UI.PADDING_DOUBLE
            verticalCenter: parent.verticalCenter
        }

        source: "image://theme/icon-m-common-drilldown-arrow-inverse"
    }

    MouseArea {
        id: mouseArea

        anchors.fill: parent
        onClicked: parent.clicked()
    }
}
