import QtQuick 1.1
import com.nokia.meego 1.0
import com.marxoft.models 1.0
import com.marxoft.enums 1.0

MySelectionDialog {
    id: root

    function setValue(value) {
        var i = 0;
        var found = false;

        while ((!found) && (i < orientationModel.count)) {
            found = (orientationModel.value(i) === value);

            if (found) {
                root.selectedIndex = i;
            }

            i++;
        }
    }

    titleText: qsTr("Screen orientation")
    model: ScreenOrientationModel {
        id: orientationModel
    }

    onAccepted: Settings.screenOrientation = orientationModel.value(root.selectedIndex)

    Component.onCompleted: root.setValue(Settings.screenOrientation)
}
