import QtQuick 1.1
import com.nokia.meego 1.0
import "scripts/createobject.js" as ObjectCreator

MySheet {
    id: root

    property alias name: nameField.text
    property string path

    signal categorySet(string name, string path)

    function showFileBrowserDialog() {
        var dialog = ObjectCreator.createObject(Qt.resolvedUrl("FileBrowserDialog.qml"), appWindow.pageStack);
        dialog.startFolder = (root.path == "" ? "/home/user/MyDocs/" : root.path);
        dialog.open();
        dialog.fileChosen.connect(root.setPath);
    }

    function setPath(p) {
        root.path = p;
    }

    rejectButtonText: qsTr("Cancel")
    acceptButtonText: (nameField.text == "") || (root.path == "") ? "" : qsTr("Done")
    content: Item {
        id: contentItem

        anchors.fill: parent
        clip: true

        Flickable {
            id: flicker

            anchors {
                fill: parent
                topMargin: UI.PADDING_DOUBLE
                leftMargin: UI.PADDING_DOUBLE
                rightMargin: UI.PADDING_DOUBLE
            }

            contentHeight: column.height

            Column {
                id: column

                anchors {
                    top: parent.top
                    left: parent.left
                    right: parent.right
                }

                spacing: UI.PADDING_DOUBLE

                Label {
                    text: qsTr("Name")
                }

                TextField {
                    id: nameField

                    width: parent.width
                    platformSipAttributes: SipAttributes {
                        actionKeyEnabled: nameField.text != ""
                        actionKeyHighlighted: true
                        actionKeyLabel: qsTr("Done")
                        actionKeyIcon: ""
                    }

                    Keys.onEnterPressed: nameField.platformCloseSoftwareInputPanel()
                    Keys.onReturnPressed: nameField.platformCloseSoftwareInputPanel()
                }

                SelectionItem {
                    id: pathSelector

                    x: -10
                    width: parent.width + 20
                    title: qsTr("Download path")
                    subTitle: root.path == "" ? qsTr("None chosen") : root.path
                    onClicked: root.showFileBrowserDialog()
                }
            }
        }

        ScrollDecorator {
            flickableItem: flicker
        }
    }

    onAccepted: root.categorySet(nameField.text, root.path)
}
