import QtQuick 1.1
import com.nokia.meego 1.0
import com.marxoft.models 1.0

SelectionDialog {
    id: root

    signal valueChosen(string value)

    function setValue(value) {
        var i = 0;
        var found = false;

        while ((!found) && (i < categoriesModel.count)) {
            found = (categoriesModel.name(i) === value);

            if (found) {
                root.selectedIndex = i;
            }

            i++;
        }
    }

    titleText: qsTr("Category")
    model: CategoriesModel {
        id: categoriesModel
    }

    onAccepted: root.valueChosen(categoriesModel.data(root.selectedIndex, "name"))
}
