#include "xhamster.h"
#include <QNetworkAccessManager>
#include <QNetworkReply>
#include <QNetworkRequest>
#include <QRegExp>

XHamster::XHamster(QObject *parent) :
    ServicePlugin(parent)
{
}

QRegExp XHamster::urlPattern() const {
    return QRegExp("http(s|)://(www.|)xhamster.com/movies/\\d+", Qt::CaseInsensitive);
}

bool XHamster::urlSupported(const QUrl &url) const {
    return this->urlPattern().indexIn(url.toString()) == 0;
}

void XHamster::checkUrl(const QUrl &webUrl) {
    QNetworkRequest request(webUrl);
    QNetworkReply *reply = this->networkAccessManager()->get(request);
    this->connect(reply, SIGNAL(finished()), this, SLOT(checkUrlIsValid()));
    this->connect(this, SIGNAL(currentOperationCancelled()), reply, SLOT(deleteLater()));
}

void XHamster::checkUrlIsValid() {
    QNetworkReply* reply = qobject_cast<QNetworkReply*>(this->sender());

    if (!reply) {
        emit urlChecked(false);
        return;
    }

    QUrl redirect = reply->attribute(QNetworkRequest::RedirectionTargetAttribute).toUrl();

    if (!redirect.isEmpty()) {
        this->checkUrl(redirect);
    }
    else {
        QString response(reply->readAll());
        QString varString = response.simplified().section("var flashvars = ", 1, 1).section("; swf", 0, 0);
        QString srv = varString.section("'srv': '", 1, 1).section("'", 0, 0);
        QString file = varString.section("'file': '", 1, 1).section("'", 0, 0);

        if ((!srv.isEmpty()) && (!file.isEmpty())) {
            QUrl url(varString.section("xmlfile': '", 1, 1).section("', ", 0, 0));
            QString fileName = QByteArray::fromPercentEncoding(url.queryItemValue("title").toUtf8()).replace('+', ' ') + ".flv";
            emit urlChecked(true, reply->request().url(), this->serviceName(), fileName);
        }
        else {
            emit urlChecked(false);
        }
    }

    reply->deleteLater();
}

void XHamster::getDownloadRequest(const QUrl &webUrl) {
    emit statusChanged(Connecting);
    QNetworkRequest request(webUrl);
    QNetworkReply *reply = this->networkAccessManager()->get(request);
    this->connect(reply, SIGNAL(finished()), this, SLOT(parseVideoPage()));
    this->connect(this, SIGNAL(currentOperationCancelled()), reply, SLOT(deleteLater()));
}

void XHamster::parseVideoPage() {
    QNetworkReply* reply = qobject_cast<QNetworkReply*>(this->sender());

    if (!reply) {
        emit error(NetworkError);
        return;
    }

    QString response(reply->readAll());
    QString varString = response.simplified().section("var flashvars = ", 1, 1).section("; swf", 0, 0);
    QString srv = varString.section("'srv': '", 1, 1).section("'", 0, 0);
    QString file = varString.section("'file': '", 1, 1).section("'", 0, 0);

    if ((!srv.isEmpty()) && (!file.isEmpty())) {
        if (file.startsWith("http")) {
            QNetworkRequest request;
            request.setUrl(QUrl(file));
            emit downloadRequestReady(request);
        }
        else {
            QNetworkRequest request;
            request.setUrl(QUrl(QString("%1/key=%2").arg(srv, file)));
            emit downloadRequestReady(request);
        }
    }
    else {
        emit error(UrlError);
    }

    reply->deleteLater();
}

bool XHamster::cancelCurrentOperation() {
    emit currentOperationCancelled();

    return true;
}

Q_EXPORT_PLUGIN2(xhamster, XHamster)
