#ifndef URLCHECKER_H
#define URLCHECKER_H

#include <QObject>
#include <QUrl>
#include <QQueue>
#include <QStringList>
#include <QAbstractTableModel>

class UrlCheckModel;

class UrlChecker : public QObject
{
    Q_OBJECT

    Q_PROPERTY(int progress
               READ progress
               NOTIFY progressChanged)

public:
    ~UrlChecker();

    UrlCheckModel* model();
    int progress() const;

    static UrlChecker* instance();

public slots:
    void addUrlToQueue(const QUrl &url);
    void addUrlToQueue(const QString &url);
    void addUrlsToQueue(QList<QUrl> urls);
    void addUrlsToQueue(QStringList urls);
    void parseUrlsFromText(const QString &text);
    void importUrlsFromTextFile(const QString &filePath);
    void cancel();

private:
    UrlChecker();

    void testFileDownload(const QUrl &url);

private slots:
    void connectToPluginSignals();
    void checkUrl(const QUrl &url);
    void checkFileDownload();
    void onUrlChecked(bool ok, const QUrl &url, const QString &service, const QString &fileName, bool done);

signals:
    void urlReady(const QUrl &url, const QString &service, const QString &fileName);
    void progressChanged(int progress);
    void cancelled();
    
private:
    static UrlChecker *m_instance;

    UrlCheckModel* m_model;
    QQueue<QUrl> m_urlQueue;
    int m_index;
    bool m_cancelled;
};

typedef struct {
    QString url;
    bool checked;
    bool ok;
} UrlCheck;

class UrlCheckModel : public QAbstractTableModel
{
    Q_OBJECT

    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)

    friend class UrlChecker;

public:
    enum Roles {
        UrlRole = Qt::UserRole + 1,
        CheckedRole,
        OkRole
    };

    ~UrlCheckModel();

#if QT_VERSION >= 0x050000
    QHash<int, QByteArray> roleNames() const;
#endif
    int rowCount(const QModelIndex &parent = QModelIndex()) const;
    int columnCount(const QModelIndex &parent = QModelIndex()) const;
    QVariant headerData(int section, Qt::Orientation orientation, int role) const;
    QVariant data(const QModelIndex &index, int role) const;
#if QT_VERSION >= 0x040600
    Q_INVOKABLE QVariant data(int row, const QByteArray &role) const;
#endif

public slots:
    void clear();

private:
    explicit UrlCheckModel(QObject *parent = 0);

    bool setData(const QModelIndex &index, const QVariant &value, int role);
    void addUrlCheck(const QString &url, bool checked = false, bool ok = false);
    void urlChecked(int row, bool ok);
    void urlChecked(const QString &url, bool ok);
    void removeUrlCheck(int row);

signals:
    void countChanged(int count);

private:
    QList<UrlCheck> m_list;
#if QT_VERSION >= 0x040600
    QHash<int, QByteArray> m_roleNames;
#endif
};

#endif // URLCHECKER_H
