#ifndef SERVICEACCOUNTSMODEL_H
#define SERVICEACCOUNTSMODEL_H

#include <QAbstractTableModel>

typedef struct {
    QString serviceName;
    QString serviceIcon;
    QString username;
    QString password;
} ServiceAccount;

class ServiceAccountsModel : public QAbstractTableModel
{
    Q_OBJECT

    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)

public:
    enum Roles {
        ServiceNameRole = Qt::UserRole + 1,
        ServiceIconRole,
        UsernameRole,
        PasswordRole
    };

public:
    explicit ServiceAccountsModel(QObject *parent = 0);
    ~ServiceAccountsModel();
#if QT_VERSION >= 0x050000
    QHash<int, QByteArray> roleNames() const;
#endif
    int rowCount(const QModelIndex &parent = QModelIndex()) const;
    int columnCount(const QModelIndex &parent = QModelIndex()) const;
    QVariant headerData(int section, Qt::Orientation orientation, int role) const;
    QVariant data(const QModelIndex &index, int role) const;
#if QT_VERSION >= 0x040600
    Q_INVOKABLE QVariant data(int row, const QByteArray &role) const;
#endif
    Q_INVOKABLE void loadAccounts();

public slots:
    void addAccount(const QString &serviceName, const QString &username, const QString &password);
    void removeAccount(const QString &serviceName);

signals:
    void countChanged(int count);
    
private:
    QList<ServiceAccount> m_list;
#if QT_VERSION >= 0x040600
    QHash<int, QByteArray> m_roleNames;
#endif
};

#endif // SERVICEACCOUNTSMODEL_H
