#include "../shared/session.h"
#include "../shared/transfermodel.h"
#include "../shared/pluginmanager.h"
#include "../shared/settings.h"
#include "../shared/urlchecker.h"
#include "../shared/urlretriever.h"
#include "../shared/clipboardmonitor.h"
#include "../shared/database.h"
#include "../shared/selectionmodels.h"
#include "../shared/categoriesmodel.h"
#include "../shared/serviceaccountsmodel.h"
#include "../shared/decaptchaaccountsmodel.h"
#include "../shared/pluginsettingsmodel.h"
#include "../shared/definitions.h"
#include "folderlistmodel.h"
#include "qmlutils.h"
#include "maskeditem.h"
#include <QApplication>
#include <MDeclarativeCache>
#include <QtDeclarative>
#include <QGLWidget>

Q_DECL_EXPORT int main(int argc, char *argv[])
{
    QScopedPointer<QApplication> app(MDeclarativeCache::qApplication(argc, argv));
    QScopedPointer<QDeclarativeView> view(MDeclarativeCache::qDeclarativeView());
    Session session;
    QmlUtils utils;

    qRegisterMetaType<ScreenOrientation::Orientation>("ScreenOrientation::Orientation");
    qRegisterMetaType<Transfers::Status>("Transfers::Status");
    qRegisterMetaType<Transfers::Priority>("Transfers::Priority");
    qRegisterMetaType< QList<Transfer*> >("QList<Transfer*>");

    qmlRegisterType<QDeclarativeFolderListModel>("com.marxoft.models",1,0,"FolderListModel");
    qmlRegisterType<ScreenOrientationModel>("com.marxoft.models",1,0,"ScreenOrientationModel");
    qmlRegisterType<ConcurrentTransfersModel>("com.marxoft.models",1,0,"ConcurrentTransfersModel");
    qmlRegisterType<ConnectionsModel>("com.marxoft.models",1,0,"ConnectionsModel");
    qmlRegisterType<TransferPriorityModel>("com.marxoft.models",1,0,"TransferPriorityModel");
    qmlRegisterType<CategoriesModel>("com.marxoft.models",1,0,"CategoriesModel");
    qmlRegisterType<ServiceAccountsModel>("com.marxoft.models",1,0,"ServiceAccountsModel");
    qmlRegisterType<DecaptchaAccountsModel>("com.marxoft.models",1,0,"DecaptchaAccountsModel");
    qmlRegisterType<PluginSettingsModel>("com.marxoft.models",1,0,"PluginSettingsModel");
    qmlRegisterType<NetworkProxyTypeModel>("com.marxoft.models",1,0,"NetworkProxyTypeModel");
    qmlRegisterType<SelectionModel>("com.marxoft.models",1,0,"SelectionModel");
    qmlRegisterType<MaskedItem>("com.marxoft.items",1,0,"MaskedItem");
    qmlRegisterType<Transfer>("com.marxoft.items",1,0,"Transfer");

    QDeclarativeContext *context = view->rootContext();
    context->setContextProperty("TransferModel", TransferModel::instance());
    context->setContextProperty("UrlChecker", UrlChecker::instance());
    context->setContextProperty("UrlCheckModel", UrlChecker::instance()->model());
    context->setContextProperty("UrlRetreiver", UrlRetriever::instance());
    context->setContextProperty("PluginManager", PluginManager::instance());
    context->setContextProperty("ClipboardMonitor", ClipboardMonitor::instance());
    context->setContextProperty("Database", Database::instance());
    context->setContextProperty("Settings", Settings::instance());
    context->setContextProperty("Utils", &utils);
    context->setContextProperty("iconPath", ICON_PATH);

    view->setViewport(new QGLWidget());
    view->setSource(QUrl("qrc:/main.qml"));
    view->showFullScreen();

    return app->exec();
}
