import QtQuick 1.1
import com.nokia.meego 1.0
import com.marxoft.models 1.0
import com.marxoft.enums 1.0

MySelectionDialog {
    id: root

    function setValue(value) {
        var i = 0;
        var found = false;

        while ((!found) && (i < proxyTypeModel.count)) {
            found = (proxyTypeModel.value(i) === value);

            if (found) {
                root.selectedIndex = i;
            }

            i++;
        }
    }

    titleText: qsTr("Proxy type")
    model: NetworkProxyTypeModel {
        id: proxyTypeModel
    }

    onAccepted: Settings.networkProxyType = proxyTypeModel.value(root.selectedIndex)

    Component.onCompleted: root.setValue(Settings.networkProxyType)
}
