import QtQuick 1.1
import com.marxoft.models 1.0
import com.marxoft.enums 1.0

MySelectionDialog {
    id: root

    signal valueChosen(variant value)

    function setValue(value) {
        var i = 0;
        var found = false;

        while ((!found) && (i < priorityModel.count)) {
            found = (priorityModel.value(i) === value);

            if (found) {
                root.selectedIndex = i;
            }

            i++;
        }
    }

    titleText: qsTr("Priority")
    model: TransferPriorityModel {
        id: priorityModel
    }

    onAccepted: root.valueChosen(priorityModel.value(root.selectedIndex))
}
