import QtQuick 1.1
import com.nokia.meego 1.0

Item {
    id: root

    property alias text: label.text

    height: 80
    width: !parent ? implicitWidth : parent.width

    Label {
        id: label

        anchors {
            right: parent.right
            rightMargin: UI.PADDING_DOUBLE
            verticalCenter: parent.verticalCenter
        }

        font.pixelSize: 18
        font.bold: true
        color: UI.COLOR_INVERTED_SECONDARY_FOREGROUND
        horizontalAlignment: Text.AlignRight
        verticalAlignment: Text.AlignVCenter
    }

    Rectangle {
        height: 1
        anchors {
            left: parent.left
            leftMargin: UI.PADDING_DOUBLE
            right: label.left
            rightMargin: UI.PADDING_DOUBLE
            verticalCenter: label.verticalCenter
        }

        color: UI.COLOR_INVERTED_SECONDARY_FOREGROUND
    }
}
