#include "decaptchaaccountsmodel.h"
#include "session.h"

DecaptchaAccountsModel::DecaptchaAccountsModel(Session *session, QObject *parent) :
    QAbstractTableModel(parent),
    m_session(session)
{
    QHash<int, QByteArray> roles;
    roles[ServiceNameRole] = "serviceName";
    roles[ServiceIconRole] = "serviceIcon";
    roles[UsernameRole] = "username";
    roles[PasswordRole] = "password";

    this->setRoleNames(roles);

    if (this->session()) {
        this->loadAccounts();
    }
}

void DecaptchaAccountsModel::setSession(Session *session) {
    m_session = session;

    if (this->session()) {
        this->loadAccounts();
    }
}

int DecaptchaAccountsModel::rowCount(const QModelIndex &parent) const {
    Q_UNUSED(parent)

    return m_list.size();
}

int DecaptchaAccountsModel::columnCount(const QModelIndex &parent) const {
    Q_UNUSED(parent)

    return 3;
}

QVariant DecaptchaAccountsModel::headerData(int section, Qt::Orientation orientation, int role) const {
    if ((role != Qt::DisplayRole) || (orientation != Qt::Horizontal)) {
        return QVariant();
    }

    switch (section) {
    case 0:
        return tr("Service");
    case 1:
        return QString("%1/%2").arg(tr("Username")).arg(tr("email"));
    case 2:
        return tr("Password");
    default:
        return QVariant();
    }
}

QVariant DecaptchaAccountsModel::data(const QModelIndex &index, int role) const {
    switch (role) {
    case ServiceNameRole:
        return m_list.at(index.row()).serviceName;
    case ServiceIconRole:
        return m_list.at(index.row()).serviceIcon;
    case UsernameRole:
        return m_list.at(index.row()).username;
    case PasswordRole:
        return m_list.at(index.row()).password;
    default:
        return QVariant();
    }
}

QVariant DecaptchaAccountsModel::data(int row, int role) const {
    return this->data(this->index(row, 0), role);
}

QString DecaptchaAccountsModel::serviceName(int row) const {
    return this->data(row, ServiceNameRole).toString();
}

QString DecaptchaAccountsModel::serviceIcon(int row) const {
    return this->data(row, ServiceIconRole).toString();
}

QString DecaptchaAccountsModel::username(int row) const {
    return this->data(row, UsernameRole).toString();
}

QString DecaptchaAccountsModel::password(int row) const {
    return this->data(row, PasswordRole).toString();
}

void DecaptchaAccountsModel::loadAccounts() {
    this->beginResetModel();
    m_list.clear();

    for (int i = 0; i < this->session()->pluginManager()->decaptchaPlugins().size(); i++) {
        DecaptchaPlugin *plugin = this->session()->pluginManager()->decaptchaPlugins().at(i);

        if (plugin) {
            QPair<QString, QString> account = this->session()->database()->getAccount(plugin->serviceName());
            DecaptchaAccount decaptchaAccount;
            decaptchaAccount.serviceName = plugin->serviceName();
            decaptchaAccount.serviceIcon = plugin->iconName();
            decaptchaAccount.username = account.first;
            decaptchaAccount.password = account.second;
            m_list.append(decaptchaAccount);
        }
    }

    this->endResetModel();

    emit countChanged(this->rowCount());
}

void DecaptchaAccountsModel::addAccount(const QString &serviceName, const QString &username, const QString &password) {
    if (this->session()->database()->addAccount(serviceName, username, password)) {
        this->loadAccounts();
    }
}

void DecaptchaAccountsModel::removeAccount(const QString &serviceName) {
    if (this->session()->database()->removeAccount(serviceName)) {
        this->loadAccounts();
    }
}
