#ifndef CATEGORIESMODEL_H
#define CATEGORIESMODEL_H

#include <QAbstractTableModel>

class Session;

class CategoriesModel : public QAbstractTableModel
{
    Q_OBJECT

    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)
    Q_PROPERTY(Session *session
               READ session
               WRITE setSession)

    Q_ENUMS(CategoriesModel::Roles)

public:
    enum Roles {
        NameRole = Qt::UserRole + 1,
        PathRole
    };

public:
    explicit CategoriesModel(Session *session = 0, QObject *parent = 0);
    int rowCount(const QModelIndex &parent = QModelIndex()) const;
    int columnCount(const QModelIndex &parent = QModelIndex()) const;
    QVariant headerData(int section, Qt::Orientation orientation, int role) const;
    QVariant data(const QModelIndex &index, int role) const;
    Q_INVOKABLE QVariant data(int row, int role) const;
    Q_INVOKABLE QString name(int row) const;
    Q_INVOKABLE QString path(int row) const;
    Q_INVOKABLE void loadCategories();
    inline Session *session() const { return m_session; }
    void setSession(Session *session);

public slots:
    void addCategory(const QString &name, const QString &path);
    void removeCategory(const QString &name);
    void removeCategory(int row);

signals:
    void countChanged(int count);

private:
    Session *m_session;
    QList< QPair<QString, QString> > m_list;
};

#endif // CATEGORIESMODEL_H
