#include "transferstatusdelegate.h"
#include "../shared/transfermodel.h"
#include <QPainter>

TransferStatusDelegate::TransferStatusDelegate(QObject *parent) :
    QStyledItemDelegate(parent)
{
}

void TransferStatusDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const {
    if ((option.state) & (QStyle::State_Selected)) {
        painter->drawImage(option.rect, QImage("/etc/hildon/theme/images/TouchListBackgroundPressed.png"));
    }

    QRect imageRect = option.rect;
    imageRect.moveTopLeft(QPoint(imageRect.left() + 21, imageRect.top() + 6));
    imageRect.setSize(QSize(48, 48));

    Transfers::Status status = static_cast<Transfers::Status>(index.data(TransferModel::StatusRole).toInt());

    switch (status) {
    case Transfers::Paused:
        painter->drawImage(imageRect, QImage("/etc/hildon/theme/mediaplayer/Pause.png"));
        break;
    case Transfers::Connecting:
        painter->drawImage(imageRect, QImage("/usr/share/icons/hicolor/48x48/hildon/general_packetdata.png"));
        break;
    case Transfers::ShortWait:
        painter->drawImage(imageRect, QImage("/usr/share/icons/hicolor/48x48/hildon/general_clock.png"));
        break;
    case Transfers::LongWait:
        painter->drawImage(imageRect, QImage("/usr/share/icons/hicolor/48x48/hildon/general_clock.png"));
        break;
    case Transfers::Downloading:
        painter->drawImage(imageRect, QImage("/usr/share/icons/hicolor/48x48/hildon/as_proxy_attachment_download.png"));
        break;
    case Transfers::Converting:
        painter->drawImage(imageRect, QImage("/usr/share/icons/hicolor/48x48/hildon/general_audio_file.png"));
        break;
    case Transfers::Failed:
        painter->drawImage(imageRect, QImage("/usr/share/icons/hicolor/48x48/hildon/general_stop.png"));
        break;
    default:
        painter->drawImage(imageRect, QImage("/etc/hildon/theme/mediaplayer/Stop.png"));
    }
}

QSize TransferStatusDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index) const {
    Q_UNUSED(index);

    return QSize(option.rect.width(), 60);
}
