#include "transfersizedelegate.h"
#include "../shared/transfermodel.h"
#include "../shared/utils.h"
#include <QPainter>

TransferSizeDelegate::TransferSizeDelegate(QObject *parent) :
    QStyledItemDelegate(parent)
{
}

void TransferSizeDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const {
    painter->save();

    if ((option.state) & (QStyle::State_Selected)) {
        painter->drawImage(option.rect, QImage("/etc/hildon/theme/images/TouchListBackgroundPressed.png"));
    }

    QFont font;
    font.setPixelSize(20);

    qint64 size = index.data(TransferModel::SizeRole).toLongLong();

    painter->setFont(font);
    painter->drawText(option.rect, Qt::AlignCenter, size > 0 ? Utils::fileSizeFromBytes(size) : "-");
    painter->restore();
}

QSize TransferSizeDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index) const {
    Q_UNUSED(index);

    return QSize(option.rect.width(), 60);
}
