#ifndef TRANSFERCATEGORYSELECTOR_H
#define TRANSFERCATEGORYSELECTOR_H

#include <QMaemo5ValueButton>

class Session;
class SelectionModel;
class QMaemo5ListPickSelector;

class TransferCategorySelector : public QMaemo5ValueButton
{
    Q_OBJECT

public:
    explicit TransferCategorySelector(Session *session, const QString &text, QWidget *parent = 0);
    void setValue(const QString &value);
    QString currentValue();

private:
    void loadCategories();

private slots:
    void onSelected();

signals:
    void valueChanged(const QString &value);

private:
    Session *m_session;
    SelectionModel *m_model;
    QMaemo5ListPickSelector *m_selector;
};

#endif // CATEGORYSELECTOR_H
