#include "transfercategorydelegate.h"
#include "../shared/transfermodel.h"
#include <QPainter>

TransferCategoryDelegate::TransferCategoryDelegate(QObject *parent) :
    QStyledItemDelegate(parent)
{
}

void TransferCategoryDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const {
    painter->save();

    if ((option.state) & (QStyle::State_Selected)) {
        painter->drawImage(option.rect, QImage("/etc/hildon/theme/images/TouchListBackgroundPressed.png"));
    }

    QFont font;
    font.setPixelSize(20);

    painter->setFont(font);
    painter->drawText(option.rect, Qt::AlignCenter, index.data(TransferModel::CategoryRole).toString());
    painter->restore();
}

QSize TransferCategoryDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index) const {
    Q_UNUSED(index);

    return QSize(option.rect.width(), 60);
}
