#include "settingsdialog.h"
#include "categoriesdialog.h"
#include "serviceaccountsdialog.h"
#include "decaptchaaccountsdialog.h"
#include "separatorlabel.h"
#include "listview.h"
#include "pluginsettingsdelegate.h"
#include "pluginsettingsdialog.h"
#include "networkproxydialog.h"
#include "concurrenttransfersselector.h"
#include "../shared/pluginsettingsmodel.h"
#include "../shared/session.h"
#include <QHBoxLayout>
#include <QDialogButtonBox>
#include <QScrollArea>
#include <QFileDialog>
#include <QPushButton>
#include <QCheckBox>

SettingsDialog::SettingsDialog(Session *session, QWidget *parent) :
    QDialog(parent),
    m_session(session),
    m_pathSelector(new QMaemo5ValueButton(tr("Default download path"), this)),
    m_statusCheckbox(new QCheckBox(tr("Start downloads automatically"), this)),
    m_concurrentSelector(new ConcurrentTransfersSelector(tr("Maximum concurrent downloads"), this)),
    m_clipboardCheckbox(new QCheckBox(tr("Monitor clipboard for URLs"), this))
{
    this->setWindowTitle(tr("Settings"));
    this->setAttribute(Qt::WA_DeleteOnClose, true);

    QPushButton *categoriesButton = new QPushButton(tr("Categories"), this);
    QPushButton *servicesButton = new QPushButton(tr("Service accounts"), this);
    QPushButton *decaptchaButton = new QPushButton(tr("Decaptcha accounts"), this);
    QPushButton *proxyButton = new QPushButton(tr("Network proxy"), this);
    PluginSettingsModel *model = new PluginSettingsModel(this);
    ListView *view = new ListView(this);
    view->setModel(model);
    view->setItemDelegate(new PluginSettingsDelegate(view));
    view->setFixedHeight(model->rowCount() * view->sizeHintForRow(0));

    QDialogButtonBox *buttonBox = new QDialogButtonBox(QDialogButtonBox::Save, Qt::Vertical, this);
    QScrollArea *scrollArea = new QScrollArea(this);
    QWidget *scrollWidget = new QWidget(scrollArea);
    QVBoxLayout *vbox = new QVBoxLayout(scrollWidget);
    vbox->setContentsMargins(0, 0, 0, 0);
    vbox->addWidget(new SeparatorLabel(tr("Downloads"), this));
    vbox->addWidget(m_pathSelector);
    vbox->addWidget(m_concurrentSelector);
    vbox->addWidget(m_statusCheckbox);
    vbox->addWidget(m_clipboardCheckbox);
    vbox->addWidget(proxyButton);
    vbox->addWidget(new SeparatorLabel(tr("Categories"), this));
    vbox->addWidget(categoriesButton);
    vbox->addWidget(new SeparatorLabel(tr("Accounts"), this));
    vbox->addWidget(servicesButton);
    vbox->addWidget(decaptchaButton);
    vbox->addWidget(new SeparatorLabel(tr("Plugins"), this));
    vbox->addWidget(view);

    scrollArea->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    scrollArea->setWidgetResizable(true);
    scrollArea->setWidget(scrollWidget);

    QHBoxLayout *hbox = new QHBoxLayout(this);
    hbox->addWidget(scrollArea, 0, Qt::AlignBottom);
    hbox->addWidget(buttonBox, 0, Qt::AlignBottom);

    this->connect(m_pathSelector, SIGNAL(clicked()), this, SLOT(showFileDialog()));
    this->connect(categoriesButton, SIGNAL(clicked()), this, SLOT(showCategoriesDialog()));
    this->connect(servicesButton, SIGNAL(clicked()), this, SLOT(showServiceAccountsDialog()));
    this->connect(decaptchaButton, SIGNAL(clicked()), this, SLOT(showDecaptchaAccountsDialog()));
    this->connect(view, SIGNAL(clicked(QModelIndex)), this, SLOT(showPluginSettingsDialog(QModelIndex)));
    this->connect(proxyButton, SIGNAL(clicked()), this, SLOT(showNetworkProxyDialog()));
    this->connect(buttonBox, SIGNAL(accepted()), this, SLOT(saveSettings()));

    this->loadSettings();
}

void SettingsDialog::loadSettings() {
    m_pathSelector->setEnabled(m_session->transferManager()->rowCount() == 0);
    m_pathSelector->setValueText(m_session->settings()->downloadPath());
    m_concurrentSelector->setValue(m_session->settings()->maximumConcurrent());
    m_statusCheckbox->setChecked(m_session->settings()->startTransfersAutomatically());
    m_clipboardCheckbox->setChecked(m_session->settings()->monitorClipboard());
}

void SettingsDialog::saveSettings() {
    m_session->settings()->setDownloadPath(m_pathSelector->valueText());
    m_session->settings()->setMaximumConcurrent(m_concurrentSelector->currentValue());
    m_session->settings()->setStartTransfersAutomatically(m_statusCheckbox->isChecked());
    m_session->settings()->setMonitorClipboard(m_clipboardCheckbox->isChecked());

    this->accept();
}

void SettingsDialog::showFileDialog() {
    QString path = QFileDialog::getExistingDirectory(this, tr("Choose folder"), m_session->settings()->downloadPath());

    if (!path.isEmpty()) {
        m_pathSelector->setValueText(path);
    }
}

void SettingsDialog::showCategoriesDialog() {
    CategoriesDialog *dialog = new CategoriesDialog(m_session, this);
    dialog->open();
}

void SettingsDialog::showServiceAccountsDialog() {
    ServiceAccountsDialog *dialog = new ServiceAccountsDialog(m_session, this);
    dialog->open();
}

void SettingsDialog::showDecaptchaAccountsDialog() {
    DecaptchaAccountsDialog *dialog = new DecaptchaAccountsDialog(m_session, this);
    dialog->open();
}

void SettingsDialog::showPluginSettingsDialog(const QModelIndex &index) {
    QString name = index.data(PluginSettingsModel::PluginNameRole).toString();
    QString fileName = index.data(PluginSettingsModel::FileNameRole).toString();
    PluginSettingsDialog *dialog = new PluginSettingsDialog(name, fileName, this);
    dialog->open();
}

void SettingsDialog::showNetworkProxyDialog() {
    NetworkProxyDialog *dialog = new NetworkProxyDialog(m_session, this);
    dialog->open();
}
