#include "servicepassworddelegate.h"
#include "../shared/serviceaccountsmodel.h"
#include <QPainter>

ServicePasswordDelegate::ServicePasswordDelegate(QObject *parent) :
    QStyledItemDelegate(parent)
{
}

void ServicePasswordDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const {
    if ((option.state) & (QStyle::State_Selected)) {
        painter->drawImage(option.rect, QImage("/etc/hildon/theme/images/TouchListBackgroundPressed.png"));
    }

    QRect textRect = option.rect;
    textRect.setLeft(textRect.left() + 5);

    QString password = index.data(ServiceAccountsModel::PasswordRole).toString();

    if (!password.isEmpty()) {
        painter->drawText(textRect, Qt::AlignVCenter, QString("********"));
    }
}

QSize ServicePasswordDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index) const {
    Q_UNUSED(index)

    return QSize(option.rect.width(), 60);
}
