#include "pluginsettingsslider.h"
#include <QSettings>

PluginSettingsSlider::PluginSettingsSlider(QWidget *parent) :
    QSlider(parent)
{
    this->connect(this, SIGNAL(sliderReleased()), this, SLOT(onReleased()));
}

void PluginSettingsSlider::setKey(const QString &key) {
    m_key = key;
}

void PluginSettingsSlider::setDefaultValue(const QVariant &value) {
    m_default = value;
}

void PluginSettingsSlider::load() {
    int value = QSettings("QDL", "QDL").value(this->key(), this->defaultValue()).toInt();
    this->setValue(value);
}

void PluginSettingsSlider::onReleased() {
    if (!this->key().isEmpty()) {
        QSettings("QDL", "QDL").setValue(this->key(), this->value());
    }
}
