#include "pluginsettingsselector.h"
#include <QSettings>

PluginSettingsSelector::PluginSettingsSelector(const QString &text, QWidget *parent) :
    QMaemo5ValueButton(text, parent),
    m_model(new SelectionModel(this)),
    m_selector(new QMaemo5ListPickSelector(this))
{
    m_selector->setModel(m_model);
    this->setPickSelector(m_selector);
    this->connect(m_selector, SIGNAL(selected(QString)), this, SLOT(onSelected()));
}

void PluginSettingsSelector::setKey(const QString &key) {
    m_key = key;
}

void PluginSettingsSelector::setDefaultValue(const QVariant &value) {
    m_default = value;
}

void PluginSettingsSelector::setModel(SelectionModel *model) {
    if (this->model()) {
        delete m_model;
    }

    m_model = model;
    m_model->setParent(this);
    m_selector->setModel(m_model);
}

void PluginSettingsSelector::load() {
    if (!this->model()) {
        return;
    }

    QVariant value = QSettings("QDL", "QDL").value(this->key(), this->defaultValue());

    bool found = false;
    int i = 0;

    while ((!found) && (i < this->model()->rowCount())) {
        found = this->model()->value(i) == value;

        if (found) {
            m_selector->setCurrentIndex(i);
        }

        i++;
    }

    if (!found) {
        m_selector->setCurrentIndex(0);
    }
}

void PluginSettingsSelector::onSelected() {
    if (!this->key().isEmpty()) {
        QSettings("QDL", "QDL").setValue(this->key(), this->model()->value(m_selector->currentIndex()));
    }
}
