#include "pluginsettingscheckbox.h"
#include <QSettings>

PluginSettingsCheckbox::PluginSettingsCheckbox(QWidget *parent) :
    QCheckBox(parent)
{
    this->connect(this, SIGNAL(clicked(bool)), this, SLOT(onClicked(bool)));
}

void PluginSettingsCheckbox::setKey(const QString &key) {
    m_key = key;
}

void PluginSettingsCheckbox::setDefaultValue(const QVariant &value) {
    m_default = value;
}

void PluginSettingsCheckbox::load() {
    bool enabled = QSettings("QDL", "QDL").value(this->key(), this->defaultValue()).toBool();
    this->setChecked(enabled);
}

void PluginSettingsCheckbox::onClicked(bool checked) {
    if (!this->key().isEmpty()) {
        QSettings("QDL", "QDL").setValue(this->key(), checked);
    }
}
