#include "decaptchaaccountsdialog.h"
#include "editdecaptchaaccountdialog.h"
#include "decaptchanamedelegate.h"
#include "decaptchapassworddelegate.h"
#include "decaptchausernamedelegate.h"
#include "../shared/paths.h"
#include "../shared/session.h"
#include "../shared/decaptchaaccountsmodel.h"
#include <QTreeView>
#include <QMenu>
#include <QDialogButtonBox>
#include <QPushButton>
#include <QGridLayout>

DecaptchaAccountsDialog::DecaptchaAccountsDialog(Session *session, QWidget *parent) :
    QDialog(parent),
    m_session(session),
    m_model(new DecaptchaAccountsModel(m_session, this)),
    m_treeView(new QTreeView(this)),
    m_contextMenu(new QMenu(this))
{
    this->setWindowTitle(tr("Decaptcha accounts"));
    this->setAttribute(Qt::WA_DeleteOnClose, true);
    this->setFixedHeight(340);

    QGridLayout *grid = new QGridLayout(this);
    grid->addWidget(m_treeView, 0, 0);

    m_contextMenu->addAction(tr("Remove"), this, SLOT(removeAccount()));

    m_treeView->setModel(m_model);
    m_treeView->setItemDelegateForColumn(0, new DecaptchaNameDelegate(m_treeView));
    m_treeView->setItemDelegateForColumn(1, new DecaptchaUsernameDelegate(m_treeView));
    m_treeView->setItemDelegateForColumn(2, new DecaptchaPasswordDelegate(m_treeView));
    m_treeView->setRootIsDecorated(false);
    m_treeView->setSelectionBehavior(QTreeView::SelectRows);
    m_treeView->setContextMenuPolicy(Qt::CustomContextMenu);
    m_treeView->setEditTriggers(QTreeView::NoEditTriggers);
    m_treeView->setExpandsOnDoubleClick(false);
    m_treeView->setItemsExpandable(false);
    m_treeView->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    m_treeView->setColumnWidth(0, 300);
    m_treeView->setColumnWidth(1, 300);

    this->connect(m_treeView, SIGNAL(clicked(QModelIndex)), this, SLOT(onItemClicked(QModelIndex)));
    this->connect(m_treeView, SIGNAL(customContextMenuRequested(QPoint)), this, SLOT(showContextMenu(QPoint)));
}

void DecaptchaAccountsDialog::onItemClicked(const QModelIndex &index) {
    EditDecaptchaAccountDialog *dialog = new EditDecaptchaAccountDialog(m_session, this);
    dialog->setAccount(ICON_PATH_MAEMO_5 + index.data(DecaptchaAccountsModel::ServiceIconRole).toString(),
                       index.data(DecaptchaAccountsModel::ServiceNameRole).toString(),
                       index.data(DecaptchaAccountsModel::UsernameRole).toString(),
                       index.data(DecaptchaAccountsModel::PasswordRole).toString());

    dialog->open();
    this->connect(dialog, SIGNAL(addAccount(QString,QString,QString)), this, SLOT(addAccount(QString,QString,QString)));
}

void DecaptchaAccountsDialog::showContextMenu(const QPoint &pos) {
    if (m_treeView->currentIndex().isValid()) {
        m_contextMenu->popup(mapToGlobal(pos));
    }
}

void DecaptchaAccountsDialog::addAccount(const QString &serviceName, const QString &username, const QString &password) {
    if (m_session->database()->addAccount(serviceName, username, password)) {
        m_model->loadAccounts();
    }
}

void DecaptchaAccountsDialog::removeAccount() {
    if (m_treeView->currentIndex().isValid()) {
        QString serviceName = m_treeView->currentIndex().data(DecaptchaAccountsModel::ServiceNameRole).toString();

        if (m_session->database()->removeAccount(serviceName)) {
            if (m_session->settings()->decaptchaService() == serviceName) {
                m_session->settings()->setDecaptchaService("");
            }

            m_model->loadAccounts();
        }
    }
}
