#ifndef CHECKURLSDIALOG_H
#define CHECKURLSDIALOG_H

#include <QDialog>
#include <QHideEvent>
#include <QUrl>

class Session;
class QTreeWidget;
class QProgressBar;
class QLabel;
class QPushButton;

class CheckUrlsDialog : public QDialog
{
    Q_OBJECT

public:
    explicit CheckUrlsDialog(Session *session, QWidget *parent = 0);

protected:
    void hideEvent(QHideEvent *event);

public slots:
    void checkUrls(QList<QUrl> urls);
    void checkUrls(QStringList urls);

private slots:
    void onUrlChecked(bool ok, const QUrl &url, const QString &service, const QString &fileName, bool done);
    void resetDialog();
    
private:
    Session *m_session;
    QTreeWidget *m_view;
    QProgressBar *m_progressBar;
    QLabel *m_infoLabel;
    QPushButton *m_okButton;
    QPushButton *m_cancelButton;
};

#endif // CHECKURLSDIALOG_H
