#ifndef CATEGORIESDIALOG_H
#define CATEGORIESDIALOG_H

#include <QDialog>

class Session;
class CategoriesModel;
class QTreeView;
class QMenu;
class QModelIndex;

class CategoriesDialog : public QDialog
{
    Q_OBJECT

public:
    explicit CategoriesDialog(Session *session, QWidget *parent = 0);

private slots:
    void onItemClicked(const QModelIndex &index);
    void showContextMenu(const QPoint &pos);
    void removeCategory();
    void showNewCategoryDialog();

private:
    Session *m_session;
    CategoriesModel *m_model;
    QTreeView *m_treeView;
    QMenu *m_contextMenu;
};

#endif // CATEGORIESDIALOG_H
