#include "categoriesdialog.h"
#include "newcategorydialog.h"
#include "categorynamedelegate.h"
#include "categorypathdelegate.h"
#include "../shared/session.h"
#include "../shared/categoriesmodel.h"
#include <QTreeView>
#include <QMenu>
#include <QDialogButtonBox>
#include <QPushButton>
#include <QGridLayout>

CategoriesDialog::CategoriesDialog(Session *session, QWidget *parent) :
    QDialog(parent),
    m_session(session),
    m_model(new CategoriesModel(m_session, this)),
    m_treeView(new QTreeView(this)),
    m_contextMenu(new QMenu(this))
{
    this->setWindowTitle(tr("Categories"));
    this->setAttribute(Qt::WA_DeleteOnClose, true);
    this->setFixedHeight(340);

    QDialogButtonBox *buttonBox = new QDialogButtonBox(Qt::Vertical, this);
    QPushButton *addButton = buttonBox->addButton(tr("New"), QDialogButtonBox::ActionRole);
    QGridLayout *grid = new QGridLayout(this);
    grid->addWidget(m_treeView, 0, 0);
    grid->addWidget(buttonBox, 0, 1);

    m_treeView->setModel(m_model);
    m_treeView->setItemDelegateForColumn(0, new CategoryNameDelegate(m_treeView));
    m_treeView->setItemDelegateForColumn(1, new CategoryPathDelegate(m_treeView));
    m_treeView->setRootIsDecorated(false);
    m_treeView->setSelectionBehavior(QTreeView::SelectRows);
    m_treeView->setContextMenuPolicy(Qt::CustomContextMenu);
    m_treeView->setEditTriggers(QTreeView::NoEditTriggers);
    m_treeView->setExpandsOnDoubleClick(false);
    m_treeView->setItemsExpandable(false);
    m_treeView->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    m_treeView->setColumnWidth(0, 200);

    m_contextMenu->addAction(tr("Remove"), this, SLOT(removeCategory()));

    this->connect(m_treeView, SIGNAL(clicked(QModelIndex)), this, SLOT(onItemClicked(QModelIndex)));
    this->connect(m_treeView, SIGNAL(customContextMenuRequested(QPoint)), this, SLOT(showContextMenu(QPoint)));
    this->connect(addButton, SIGNAL(clicked()), this, SLOT(showNewCategoryDialog()));
}

void CategoriesDialog::onItemClicked(const QModelIndex &index) {
    NewCategoryDialog *dialog = new NewCategoryDialog(m_session, this);
    dialog->setWindowTitle(tr("Edit category"));
    dialog->setName(index.data(CategoriesModel::NameRole).toString());
    dialog->setPath(index.data(CategoriesModel::PathRole).toString());
    dialog->open();
    this->connect(dialog, SIGNAL(addCategory(QString,QString)), m_model, SLOT(addCategory(QString,QString)));
}

void CategoriesDialog::showContextMenu(const QPoint &pos) {
    if (m_treeView->currentIndex().isValid()) {
        m_contextMenu->popup(mapToGlobal(pos));
    }
}

void CategoriesDialog::removeCategory() {
    if (m_treeView->currentIndex().isValid()) {
        m_model->removeCategory(m_treeView->currentIndex().row());
    }
}

void CategoriesDialog::showNewCategoryDialog() {
    NewCategoryDialog *dialog = new NewCategoryDialog(m_session, this);
    dialog->open();
    this->connect(dialog, SIGNAL(addCategory(QString,QString)), m_model, SLOT(addCategory(QString,QString)));
}
