#include "addurlsdialog.h"
#include "checkurlsdialog.h"
#include "../shared/session.h"
#include <QTextEdit>
#include <QDialogButtonBox>
#include <QHBoxLayout>

AddUrlsDialog::AddUrlsDialog(Session *session, QWidget *parent) :
    QDialog(parent),
    m_session(session),
    m_urlsEdit(new QTextEdit(this))
{
    this->setWindowTitle(tr("Add URLs"));
    this->setAttribute(Qt::WA_DeleteOnClose, true);

    QDialogButtonBox *buttonBox = new QDialogButtonBox(QDialogButtonBox::Ok, Qt::Vertical, this);
    QHBoxLayout *hbox = new QHBoxLayout(this);
    hbox->addWidget(m_urlsEdit, 0, Qt::AlignBottom);
    hbox->addWidget(buttonBox, 0, Qt::AlignBottom);

    this->connect(buttonBox, SIGNAL(accepted()), this, SLOT(parseUrls()));
}

void AddUrlsDialog::parseUrls() {    
    m_session->urlChecker()->parseUrlsFromText(m_urlsEdit->toPlainText());
    this->accept();
}
