#include "treeview.h"

TreeView::TreeView(QWidget *parent) :
    QTreeView(parent),
    m_pressedRow(-1)
{
}

void TreeView::mouseMoveEvent(QMouseEvent *event) {
    QModelIndex index = this->indexAt(event->pos());

    if (!index.isValid()) {
        emit rowEntered(-1);
    }
    else {
        emit rowEntered(index.row());
    }

    event->accept();
}

void TreeView::mousePressEvent(QMouseEvent *event) {
    QModelIndex index = this->indexAt(event->pos());

    if (!index.isValid()) {
        m_pressedRow = -1;
    }
    else {
        this->setCurrentIndex(index);
        m_pressedRow = index.row();
        emit rowPressed(m_pressedRow);
    }

    event->accept();
}

void TreeView::mouseReleaseEvent(QMouseEvent *event) {
    QModelIndex index = this->indexAt(event->pos());

    if ((index.isValid()) && (index.row() == m_pressedRow)) {
        emit rowReleased(m_pressedRow);
        emit rowClicked(m_pressedRow);
    }

    m_pressedRow = -1;

    event->accept();
}
