#include "transfersizedelegate.h"
#include "../shared/transfermodel.h"
#include "../shared/utils.h"
#include <QPainter>

TransferSizeDelegate::TransferSizeDelegate(QObject *parent) :
    QStyledItemDelegate(parent)
{
}

void TransferSizeDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const {
    if (index.data(TransferModel::SelectedRole).toBool()) {
        painter->fillRect(option.rect, Qt::cyan);
    }
    else if (index.data(TransferModel::EnteredRole).toBool()) {
        painter->fillRect(option.rect, Qt::lightGray);
    }

    qint64 size = index.data(TransferModel::SizeRole).toLongLong();

    painter->drawText(option.rect, Qt::AlignCenter, size > 0 ? Utils::fileSizeFromBytes(size) : "-");
}

QSize TransferSizeDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index) const {
    Q_UNUSED(index);

    return QSize(option.rect.width(), 25);
}
