#include "pluginsettingstab.h"
#include "separatorlabel.h"
#include "pluginsettingscombobox.h"
#include "pluginsettingscheckbox.h"
#include "pluginsettingsspinbox.h"
#include "pluginsettingslineedit.h"
#include <QFile>
#include <QGridLayout>
#include <QScrollArea>
#include <QXmlStreamReader>

PluginSettingsTab::PluginSettingsTab(const QString &fileName, QWidget *parent) :
    QWidget(parent)
{
    QGridLayout *grid = new QGridLayout(this);
    QScrollArea *scrollArea = new QScrollArea(this);
    QWidget *scrollWidget = new QWidget(scrollArea);
    QVBoxLayout *vbox = new QVBoxLayout(scrollWidget);
    grid->setContentsMargins(0, 0, 0, 0);
    scrollArea->setWidgetResizable(true);
    scrollArea->setWidget(scrollWidget);

    QFile file(fileName);
    file.open(QIODevice::ReadOnly);
    QXmlStreamReader reader;
    reader.setDevice(&file);
    reader.readNextStartElement();
    QString title = reader.attributes().value("title").toString();

    while (!reader.atEnd()) {
        if (!reader.attributes().isEmpty()) {
            if (reader.name() == "group") {
                vbox->addWidget(new SeparatorLabel(reader.attributes().value("title").toString(), this));
            }
            else if (reader.name() == "list") {
                QLabel *label = new QLabel(reader.attributes().value("title").toString() + ":", this);
                PluginSettingsCombobox *combobox = new PluginSettingsCombobox(this);
                combobox->setKey(QString("%1/%2").arg(title).arg(reader.attributes().value("key").toString()));
                combobox->setDefaultValue(reader.attributes().value("default").toString());
                reader.readNextStartElement();

                while (reader.name() == "element") {
                    if (!reader.attributes().isEmpty()) {
                        combobox->addItem(reader.attributes().value("name").toString(), reader.attributes().value("value").toString());
                    }

                    reader.readNextStartElement();
                }

                combobox->load();

                vbox->addWidget(label);
                vbox->addWidget(combobox);
            }
            else if (reader.name() == "boolean") {
                PluginSettingsCheckbox *checkbox = new PluginSettingsCheckbox(this);
                checkbox->setText(reader.attributes().value("title").toString());
                checkbox->setKey(QString("%1/%2").arg(title).arg(reader.attributes().value("key").toString()));
                checkbox->setDefaultValue(reader.attributes().value("default").toString());
                checkbox->load();
                vbox->addWidget(checkbox);
            }
            else if (reader.name() == "integer") {
                PluginSettingsSpinbox *spinbox = new PluginSettingsSpinbox(this);
                spinbox->setKey(QString("%1/%2").arg(title).arg(reader.attributes().value("key").toString()));
                spinbox->setDefaultValue(reader.attributes().value("default").toString());
                spinbox->setMinimum(reader.attributes().value("min").toString().toInt());
                spinbox->setMaximum(reader.attributes().value("max").toString().toInt());
                spinbox->load();
                vbox->addWidget(new QLabel(reader.attributes().value("title").toString() + ":", this));
                vbox->addWidget(spinbox);
            }
            else if (reader.name() == "text") {
                PluginSettingsLineEdit *lineEdit = new PluginSettingsLineEdit(this);
                lineEdit->setKey(QString("%1/%2").arg(title).arg(reader.attributes().value("key").toString()));
                lineEdit->setDefaultValue(reader.attributes().value("default").toString());
                lineEdit->load();
                vbox->addWidget(new QLabel(reader.attributes().value("title").toString() + ":", this));
                vbox->addWidget(lineEdit);
            }
        }

        reader.readNextStartElement();
    }

    vbox->addSpacerItem(new QSpacerItem(10, 10, QSizePolicy::Expanding, QSizePolicy::Expanding));

    file.close();

    grid->addWidget(scrollArea);
}
