#include "pluginsettingslineedit.h"
#include <QSettings>

PluginSettingsLineEdit::PluginSettingsLineEdit(QWidget *parent) :
    QLineEdit(parent)
{
    this->connect(this, SIGNAL(textEdited(QString)), this, SLOT(onTextEdited(QString)));
}

void PluginSettingsLineEdit::setKey(const QString &key) {
    m_key = key;
}

void PluginSettingsLineEdit::setDefaultValue(const QVariant &value) {
    m_default = value;
}

void PluginSettingsLineEdit::load() {
    QString text = QSettings("QDL", "QDL").value(this->key(), this->defaultValue()).toString();
    this->setText(text);
}

void PluginSettingsLineEdit::onTextEdited(const QString &text) {
    if (!this->key().isEmpty()) {
        QSettings("QDL", "QDL").setValue(this->key(), text);
    }
}
