#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QQueue>

class Session;
class QLineEdit;
class CheckUrlsDialog;
class TreeView;
class QMenu;

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(Session *session, QWidget *parent = 0);

private slots:
    void showContextMenu(const QPoint &pos);
    void pauseResumeTransfer();
    void cancelTransfer();
    void setTransferHighPriority();
    void setTransferNormalPriority();
    void setTransferLowPriority();
    void addTransferFromUrlEdit();
    void showAddUrlsDialog();
    void showTextFileDialog();
    void showAboutDialog();

private slots:
    void showSettingsDialog();
    void setCategoryContextActions();
    void setTransferCategory();
    void setSaveTransferAsAudioFile();
    void resumeSeletctedTransfers();
    void pauseSelectedTransfers();
    void cancelSelectedTransfers();
    
private:
    Session *m_session;
    QLineEdit *m_urlEdit;
    TreeView *m_view;
    QMenu *m_contextMenu;
    QAction *m_saveAsAudioAction;
    QAction *m_contextPauseResumeAction;
    QAction *m_contextCancelAction;
    QMenu *m_priorityMenu;
    QAction *m_highPriorityAction;
    QAction *m_normalPriorityAction;
    QAction *m_lowPriorityAction;
    QMenu *m_categoryMenu;
    CheckUrlsDialog *m_checkDialog;
};

#endif // MAINWINDOW_H
