#ifndef CATEGORYSETTINGSTAB_H
#define CATEGORYSETTINGSTAB_H

#include "../shared/session.h"
#include "../shared/categoriesmodel.h"
#include <QWidget>
#include <QTreeView>
#include <QPushButton>
#include <QLineEdit>

class CategorySettingsTab : public QWidget
{
    Q_OBJECT

public:
    explicit CategorySettingsTab(Session *session, QWidget *parent = 0);

private slots:
    void onItemClicked(const QModelIndex &index);
    void addCategory();
    void removeCategory();
    void editCategory();
    void showFolderDialog();
    void onCategoryEditChanged();
    
private:
    Session *m_session;
    CategoriesModel *m_model;
    QTreeView *m_treeView;
    QPushButton *m_addButton;
    QPushButton *m_editButton;
    QPushButton *m_removeButton;
    QLineEdit *m_nameEdit;
    QLineEdit *m_pathEdit;
    QPushButton *m_browseButton;
    QPushButton *m_doneButton;
};

#endif // CATEGORYSETTINGSTAB_H
