#include "categorynamedelegate.h"
#include "../shared/categoriesmodel.h"
#include <QPainter>

CategoryNameDelegate::CategoryNameDelegate(QObject *parent) :
    QStyledItemDelegate(parent)
{
}

void CategoryNameDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const {
    painter->drawText(option.rect, Qt::AlignVCenter, index.data(CategoriesModel::NameRole).toString());
}

QSize CategoryNameDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index) const {
    Q_UNUSED(index)

    return QSize(option.rect.width(), 25);
}
