import QtQuick 1.1

SwitchItem {
    id: root

    function setKey(key, defaultValue) {
        internal.key = key;

        var value = Settings.setting(key);

        if (value === undefined) {
            root.checked = (defaultValue === "true");
        }
        else {
            root.checked = (value === "true");
        }
    }

    onCheckedChanged: Settings.setSetting(internal.key, root.checked)

    QtObject {
        id: internal

        property string key
    }
}
