#include "captchaimageprovider.h"
#include <QDebug>

CaptchaImageProvider::CaptchaImageProvider() :
    QDeclarativeImageProvider(QDeclarativeImageProvider::Pixmap)
{
}

QPixmap CaptchaImageProvider::requestPixmap(const QString &id, QSize *size, const QSize &requestedSize) {
    if (size) {
        *size = QSize(400, 200);
    }

    QPixmap pixmap(requestedSize.width() > 0 ? requestedSize.width() : 400,
                   requestedSize.height() > 0 ? requestedSize.height() : 200);

    if (!pixmap.loadFromData(QByteArray::fromBase64(id.toAscii()))) {
        qDebug() << "Cannot load pixmap from data";
    }

    return pixmap;
}
