#ifndef SESSION_H
#define SESSION_H

#include "settings.h"
#include "database.h"
#include "transfermodel.h"
#include "cookiejar.h"
#include "urlchecker.h"
#include <QQueue>
#include <QStringList>

class QProgressDialog;
class QThread;
class QTimer;

class Session : public QObject
{
    Q_OBJECT

public:
    explicit Session(QObject *parent = 0);
    ~Session();
    inline Settings* settings() const { return m_settings; }
    inline Database* database() const { return m_database; }
    inline TransferModel* transferManager() const { return m_transferManager; }
    inline CookieJar* cookieJar() const { return m_jar; }
    inline QNetworkAccessManager* networkAccessManager() const { return m_nam; }
    inline UrlChecker* urlChecker() const { return m_checker; }
    inline PluginManager* pluginManager() const { return m_manager; }
    int concurrentDownloads() const;

public slots:
    void onUrlChecked(bool ok, const QUrl &url, const QString &service, const QString &fileName);
    void addTransfer(const QUrl &webUrl, const QString &service, const QString &fileName);
    void showProgressDialog(const QString &message, int numberOfOperations);
    void updateProgressDialog(int progress);
    void cancelProgressDialog();

private:
    QString generateTransferId(QString seedFileName) const;
    QSharedPointer<TransferItem> getNextTransfer() const;

private slots:
    void restoreStoredDownloads();
    void onTransferStatusChanged(Transfers::Status status);
    void onTransferCategoryChanged(const QString &category);
    void onTransferFileNameChanged(const QString &fileName);
    void onTransferPriorityChanged(Transfers::Priority priority);
    void onTransferSaveAsAudioChanged(bool saveAsAudio);
    void onTransferRowChanged(uint row);
    void onTransferCompleted(QSharedPointer<TransferItem> transfer);
    void onTransferCancelled(QSharedPointer<TransferItem> transfer);
    void onMaximumConcurrentChanged(int oldMaximum, int newMaximum);
    void onMonitorClipboardChanged(bool monitor);
    void onClipboardTextChanged();
    
private:
    Settings *m_settings;
    Database *m_database;
    TransferModel *m_transferManager;
    CookieJar *m_jar;
    QNetworkAccessManager *m_nam;
    UrlChecker *m_checker;
    PluginManager *m_manager;
    QProgressDialog *m_progressDialog;
    QThread *m_thread;
    QTimer *m_clipboardTimer; // For Harmhattan
};

#endif // SESSION_H
