#ifndef PLUGINSETTINGSMODEL_H
#define PLUGINSETTINGSMODEL_H

#include <QAbstractListModel>

typedef struct {
    QString name;
    QString icon;
    QString fileName;
} Setting;

class PluginSettingsModel : public QAbstractListModel
{
    Q_OBJECT

    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)

public:
    enum Roles {
        PluginNameRole = Qt::UserRole + 1,
        PluginIconRole,
        FileNameRole
    };

public:
    explicit PluginSettingsModel(QObject *parent = 0);
    int rowCount(const QModelIndex &parent = QModelIndex()) const;
    QVariant data(const QModelIndex &index, int role) const;

public slots:
    void loadSettingsFiles();

signals:
    void countChanged(int count);
    
private:
    QList<Setting> m_list;
};

#endif // PLUGINSETTINGSMODEL_H
