#ifndef PLUGINMANAGER_H
#define PLUGINMANAGER_H

#include <QObject>
#include <QQueue>
#include <QStringList>

class ServicePlugin;
class DecaptchaPlugin;
class RecaptchaPlugin;
class Database;
class QNetworkAccessManager;
class QUrl;

class PluginManager : public QObject
{
    Q_OBJECT

public:
    explicit PluginManager(QObject *parent = 0);
    inline Database* database() const { return m_database; }
    void setDatabase(Database *database) { m_database = database; }
    inline QNetworkAccessManager* networkAccessManager() const { return m_nam; }
    void setNetworkAccessManager(QNetworkAccessManager* manager) { m_nam = manager; }
    void loadPlugins();
    ServicePlugin* getServicePlugin(const QString &serviceName) const;
    ServicePlugin* getServicePlugin(const QUrl &url) const;
    ServicePlugin* createServicePlugin(const QString &serviceName);
    ServicePlugin* createServicePlugin(const QUrl &url);
    inline QList<ServicePlugin*> servicePlugins() const { return m_services; }
    DecaptchaPlugin* getDecaptchaPlugin(const QString &serviceName) const;
    DecaptchaPlugin* createDecaptchaPlugin(const QString &serviceName);
    inline QList<DecaptchaPlugin*> decaptchaPlugins() const { return m_decaptchaServices; }
    RecaptchaPlugin* getRecaptchaPlugin(const QString &serviceName) const;
    RecaptchaPlugin* createRecaptchaPlugin(const QString &serviceName);
    inline QList<RecaptchaPlugin*> recaptchaPlugins() const { return m_recaptchaServices; }
    inline QStringList servicePluginNames() const { return m_serviceNames; }
    inline QStringList decaptchaPluginNames() const { return m_decaptchaNames; }

private:
    void loadServicePlugins();
    void loadDecaptchaPlugins();
    void loadRecaptchaPlugins();
    void loginToAccounts();

private slots:
    void onAccountLogin(bool ok);

signals:
    void busy(const QString &message, int numberOfOperations);
    void busyProgressChanged(int progress);
    void pluginsReady();
    
private:
    Database *m_database;
    QNetworkAccessManager *m_nam;
    QList<ServicePlugin*> m_services;
    QStringList m_serviceNames;
    QQueue<ServicePlugin*> m_loginQueue;
    QList<QString> m_paths;
    QList<DecaptchaPlugin*> m_decaptchaServices;
    QStringList m_decaptchaNames;
    QList<RecaptchaPlugin*> m_recaptchaServices;
    int m_progress;
};

#endif // PLUGINMANAGER_H
