#ifndef ENUMS_H
#define ENUMS_H

#include <QObject>
#include <QNetworkProxy>

class ScreenOrientation : public QObject
{
    Q_OBJECT

    Q_ENUMS(Orientation)

public:
    enum Orientation {
        Automatic = 0,
        LockPortrait,
        LockLandscape
    };
};

class Transfers : public QObject
{
    Q_OBJECT

    Q_ENUMS(Status Priority)

public:
    enum Status {
        Paused = 0,
        LongWait,
        Cancelled,
        Failed,
        Completed,
        Queued,
        Connecting,
        ShortWait,
        Downloading,
        Converting
    };

    enum Priority {
        HighPriority = 0,
        NormalPriority,
        LowPriority
    };
};

class NetworkProxyType : public QObject
{
    Q_OBJECT

    Q_ENUMS(ProxyType)

public:
    enum ProxyType {
        Socks5Proxy = QNetworkProxy::Socks5Proxy,
        HttpProxy = QNetworkProxy::HttpProxy,
        HttpCachingProxy = QNetworkProxy::HttpCachingProxy
    };
};

#endif // ENUMS_H
