#ifndef DECAPTCHAACCOUNTSMODEL_H
#define DECAPTCHAACCOUNTSMODEL_H

#include <QAbstractTableModel>

typedef struct {
    QString serviceName;
    QString serviceIcon;
    QString username;
    QString password;
} DecaptchaAccount;

class Session;

class DecaptchaAccountsModel : public QAbstractTableModel
{
    Q_OBJECT

    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)
    Q_PROPERTY(Session *session
               READ session
               WRITE setSession)

    Q_ENUMS(DecaptchaAccountsModel::Roles)

public:
    enum Roles {
        ServiceNameRole = Qt::UserRole + 1,
        ServiceIconRole,
        UsernameRole,
        PasswordRole
    };

public:
    explicit DecaptchaAccountsModel(Session *session = 0, QObject *parent = 0);
    int rowCount(const QModelIndex &parent = QModelIndex()) const;
    int columnCount(const QModelIndex &parent = QModelIndex()) const;
    QVariant headerData(int section, Qt::Orientation orientation, int role) const;
    QVariant data(const QModelIndex &index, int role) const;
    Q_INVOKABLE QVariant data(int row, int role) const;
    Q_INVOKABLE QString serviceName(int row) const;
    Q_INVOKABLE QString serviceIcon(int row) const;
    Q_INVOKABLE QString username(int row) const;
    Q_INVOKABLE QString password(int row) const;
    Q_INVOKABLE void loadAccounts();
    inline Session* session() const { return m_session; }
    void setSession(Session *session);

public slots:
    void addAccount(const QString &serviceName, const QString &username, const QString &password);
    void removeAccount(const QString &serviceName);

signals:
    void countChanged(int count);

private:
    Session *m_session;
    QList<DecaptchaAccount> m_list;
};

#endif // DECAPTCHAACCOUNTSMODEL_H
