#include "categoriesmodel.h"
#include "session.h"

CategoriesModel::CategoriesModel(Session *session, QObject *parent) :
    QAbstractTableModel(parent),
    m_session(session)
{
    QHash<int, QByteArray> roles;
    roles[NameRole] = "name";
    roles[PathRole] = "path";

    this->setRoleNames(roles);

    if (this->session()) {
        this->loadCategories();
    }
}

void CategoriesModel::setSession(Session *session) {
    m_session = session;

    if (this->session()) {
        this->loadCategories();
    }
}

int CategoriesModel::rowCount(const QModelIndex &parent) const {
    Q_UNUSED(parent)

    return m_list.size();
}

int CategoriesModel::columnCount(const QModelIndex &parent) const {
    Q_UNUSED(parent)

    return 2;
}

QVariant CategoriesModel::headerData(int section, Qt::Orientation orientation, int role) const {
    if ((role != Qt::DisplayRole) || (orientation != Qt::Horizontal)) {
        return QVariant();
    }

    switch (section) {
    case 0:
        return tr("Name");
    case 1:
        return tr("Download path");
    default:
        return QVariant();
    }
}

QVariant CategoriesModel::data(const QModelIndex &index, int role) const {
    switch (role) {
    case NameRole:
        return m_list.at(index.row()).first;
    case PathRole:
        return m_list.at(index.row()).second;
    default:
        return QVariant();
    }
}

QVariant CategoriesModel::data(int row, int role) const {
    return this->data(this->index(row, 0), role);
}

QString CategoriesModel::name(int row) const {
    return this->data(row, NameRole).toString();
}

QString CategoriesModel::path(int row) const {
    return this->data(row, PathRole).toString();
}

void CategoriesModel::loadCategories() {
    this->beginResetModel();
    m_list.clear();
    m_list = this->session()->database()->getCategories();
    this->endResetModel();
    emit countChanged(this->rowCount());
}

void CategoriesModel::addCategory(const QString &name, const QString &path) {
    if (this->session()->database()->addCategory(name, path)) {
        this->loadCategories();
    }
}

void CategoriesModel::removeCategory(const QString &name) {
    if (this->session()->database()->removeCategory(name)) {
        this->loadCategories();
    }
}

void CategoriesModel::removeCategory(int row) {
    if (this->session()->database()->removeCategory(this->data(row, NameRole).toString())) {
        this->loadCategories();
    }
}
